/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.client.gui;

import cloud.lemonslice.teastory.client.container.DrinkMakerContainer;
import cloud.lemonslice.teastory.client.gui.RenderUtil;
import cloud.lemonslice.teastory.recipe.drink.DrinkRecipe;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import xueluoanping.teastory.TeaStory;

public class DrinkMakerGui
extends AbstractContainerScreen<DrinkMakerContainer> {
    private static final String TEXTURE_PATH = "textures/gui/container/gui_drink_maker.png";
    private static final ResourceLocation TEXTURE = TeaStory.rl("textures/gui/container/gui_drink_maker.png");
    private static final int QUESTION_X = 83;
    private static final int QUESTION_Y = 16;
    private static final int EXCLAMATION_X = 96;
    private static final int EXCLAMATION_Y = 54;
    private final DrinkMakerContainer container;
    private boolean isEnough = true;

    public DrinkMakerGui(DrinkMakerContainer container, Inventory inventory, Component name) {
        super((AbstractContainerMenu)container, inventory, name);
        this.container = container;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int offsetX = (this.f_96543_ - this.f_97726_) / 2;
        int offsetY = (this.f_96544_ - this.f_97727_) / 2;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        Minecraft.m_91087_().m_91097_().m_174784_(TEXTURE);
        guiGraphics.m_280218_(TEXTURE, offsetX, offsetY, 0, 0, this.f_97726_, this.f_97727_);
        int totalTicks = this.container.getTileEntity().getTotalTicks();
        int processTicks = this.container.getTileEntity().getProcessTicks();
        int textureWidth = 0;
        if (totalTicks != 0) {
            textureWidth = (int)Math.ceil(22.0 * (double)processTicks / (double)totalTicks);
        }
        guiGraphics.m_280218_(TEXTURE, offsetX + 99, offsetY + 37, 176, 0, textureWidth, 16);
        this.container.getTileEntity().getFluidHandler().ifPresent(f -> {
            int capacity = f.getTankCapacity(0);
            int height = capacity != 0 ? (int)Math.ceil(64.0 * (double)this.container.getTileEntity().getFluidAmount() / (double)capacity) : 0;
            FluidStack fs = f.getFluidInTank(0);
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            if (!fs.isEmpty()) {
                RenderUtil.renderFluidStackInGUI(guiGraphics.m_280168_().m_85850_().m_252922_(), fs, 16, (int)(64.0f * ((float)height / 64.0f)), offsetX + 128, offsetY + 12 + 64);
            }
            poseStack.m_85849_();
        });
        RenderSystem.disableBlend();
    }

    public void m_88315_(GuiGraphics matrixStack, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(matrixStack, mouseX, mouseY, partialTick);
        this.m_280072_(matrixStack, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics matrixStack, int mouseX, int mouseY) {
        DrinkRecipe recipe = this.container.getTileEntity().getCurrentRecipe();
        if (!this.isEnough) {
            this.isEnough = true;
        }
        if (recipe != null) {
            int n = this.container.getTileEntity().getNeededAmount();
            for (int i = 0; i < 4; ++i) {
                Slot slot = (Slot)this.container.f_38839_.get(i);
                ItemStack itemStack = slot.m_7993_();
                if (itemStack.m_41619_() || itemStack.m_41613_() >= n) continue;
                this.renderSlotWarning(matrixStack, slot.f_40220_, slot.f_40221_);
                this.isEnough = false;
            }
        }
        int offsetX = (this.f_96543_ - this.f_97726_) / 2;
        int offsetY = (this.f_96544_ - this.f_97727_) / 2;
        matrixStack.drawString(this.f_96547_, this.f_96539_.getString(), (float)this.f_97726_ / 3.0f - (float)this.f_96547_.m_92895_(this.f_96539_.getString()) / 2.0f - 1.0f, 8.0f, 14599796, false);
        matrixStack.drawString(this.f_96547_, this.f_169604_.getString(), 8.0f, (float)(this.f_97727_ - 95), 14599796, false);
        if (offsetX + 83 <= mouseX && mouseX <= offsetX + 83 + 11 && offsetY + 16 <= mouseY && mouseY <= offsetY + 16 + 11) {
            MutableComponent ingredient = Component.m_237115_((String)"info.teastory.tooltip.drink_maker.help.1");
            MutableComponent mutableComponent = Component.m_237115_((String)"info.teastory.tooltip.drink_maker.help.2");
        }
    }

    private void renderSlotWarning(GuiGraphics matrixStack, int x, int y) {
        matrixStack.m_280024_(x, y, x + 16, y + 16, -1613344956, -1613344956);
    }

    protected void m_280072_(GuiGraphics matrixStack, int mouseX, int mouseY) {
        super.m_280072_(matrixStack, mouseX, mouseY);
        if (this.container.getTileEntity().getFluidTranslation() == null) {
            return;
        }
        int offsetX = (this.f_96543_ - this.f_97726_) / 2;
        int offsetY = (this.f_96544_ - this.f_97727_) / 2;
        if (offsetX + 128 < mouseX && mouseX < offsetX + 128 + 16 && offsetY + 12 < mouseY && mouseY < offsetY + 12 + 64) {
            matrixStack.m_280666_(this.f_96547_, List.of(this.container.getTileEntity().getFluidTranslation()), mouseX, mouseY);
        }
    }
}

